{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:41:12 $                                        =}
{========================================================================}
unit fmMain;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ExtCtrls,
  StdCtrls,
  MMObj,
  MMWheel,
  MMSpin,
  MMScale,
  MMSlider;

type
  TForm1 = class(TForm)
    MMWheel1: TMMWheel;
    MMSpinButton1: TMMSpinButton;
    MMWheel2: TMMWheel;
    MMSpinButton2: TMMSpinButton;
    Label1: TLabel;
    Label2: TLabel;
    MMWheel3: TMMWheel;
    RadioGroup1: TRadioGroup;
    OwnerDrawCheck: TCheckBox;
    RadioGroup2: TRadioGroup;
    ConnectCheck: TCheckBox;
    MMSpinButton3: TMMSpinButton;
    Label3: TLabel;
    MMSlider1: TMMSlider;
    MMWheel4: TMMWheel;
    Label4: TLabel;
    MMSpinButton4: TMMSpinButton;
    MMSlider2: TMMSlider;
    procedure MMSpinButton1Change(Sender: TObject);
    procedure MMSpinButton2Change(Sender: TObject);
    procedure MMWheel1Change(Sender: TObject);
    procedure MMWheel2Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure MMWheel1DrawHandle(Sender: TObject; Canvas: TCanvas;
      Rect: TRect; Origin: TPoint; Focused: Boolean);
    procedure OwnerDrawCheckClick(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure ConnectCheckClick(Sender: TObject);
    procedure MMSpinButton3Change(Sender: TObject);
    procedure MMWheel3Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MMWheel4Change(Sender: TObject);
    procedure MMSpinButton4Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.MMSpinButton1Change(Sender: TObject);
begin
    MMWheel1.Value := MMSpinButton1.Value;
end;

procedure TForm1.MMSpinButton2Change(Sender: TObject);
begin
    MMWheel2.Value := MMSpinButton2.Value;
end;

procedure TForm1.MMWheel1Change(Sender: TObject);
begin
    Label1.Caption := IntToStr(MMWheel1.Value);
    MMSpinButton1.Value := MMWheel1.Value;
end;

procedure TForm1.MMWheel2Change(Sender: TObject);
begin
    Label2.Caption := IntToStr(MMWheel2.Value);
    MMSpinButton2.Value := MMWheel2.Value;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
    MMWheel1.Scale.Style    := MMScale.TMMScaleStyle(RadioGroup1.ItemIndex);
    MMWheel2.Scale.Style    := MMWheel1.Scale.Style ;
    MMWheel3.Scale.Style    := MMWheel1.Scale.Style ;
    MMWheel4.Scale.Style    := MMWheel1.Scale.Style ;    
    MMSlider1.Scale.Style   := MMWheel1.Scale.Style ;
    MMSlider2.Scale.Style   := MMWheel1.Scale.Style ;    
end;

procedure TForm1.MMWheel1DrawHandle(Sender: TObject; Canvas: TCanvas;
  Rect: TRect; Origin: TPoint; Focused: Boolean);
var
    R : TRect ;
begin
    R := Classes.Rect(Origin.X-3,Origin.Y-3,Origin.X+3,Origin.Y+3) ;
    if Focused then
        Frame3D(Canvas,R,clRed,clMaroon,2)
    else
        Frame3D(Canvas,R,clWhite,clBlack,2);
end;

procedure TForm1.OwnerDrawCheckClick(Sender: TObject);
begin
    if OwnerDrawCheck.Checked then begin
        MMWheel1.HandleStyle := hsOwnerDraw ;
        MMWheel2.HandleStyle := hsOwnerDraw ;
        MMWheel3.HandleStyle := hsOwnerDraw ;
        MMWheel4.HandleStyle := hsOwnerDraw ;
    end else begin
        MMWheel1.HandleStyle := hsEllipse ;
        MMWheel2.HandleStyle := hsEllipse ;
        MMWheel3.HandleStyle := hsEllipse ;
        MMWheel4.HandleStyle := hsEllipse ;
    end;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
    MMWheel1.Scale.Origin := TMMScaleOrigin(RadioGroup2.ItemIndex);
    MMWheel2.Scale.Origin := MMWheel1.Scale.Origin ;
    MMWheel3.Scale.Origin := MMWheel1.Scale.Origin ;
    MMWheel4.Scale.Origin := MMWheel1.Scale.Origin ;    
    MMSlider1.Scale.Origin:= MMWheel1.Scale.Origin ;
    MMSlider2.Scale.Origin:= MMWheel1.Scale.Origin ;    
end;

procedure TForm1.ConnectCheckClick(Sender: TObject);
begin
    MMWheel1.Scale.Connect := ConnectCheck.Checked ;
    MMWheel2.Scale.Connect := ConnectCheck.Checked ;
    MMWheel3.Scale.Connect := ConnectCheck.Checked ;
    MMWheel4.Scale.Connect := ConnectCheck.Checked ;
    MMSlider1.Scale.Connect:= ConnectCheck.Checked ;
    MMSlider2.Scale.Connect:= ConnectCheck.Checked ;    
end;

procedure TForm1.MMSpinButton3Change(Sender: TObject);
begin
    MMWheel3.Value := MMSpinButton3.Value;
end;

procedure TForm1.MMWheel3Change(Sender: TObject);
begin
    Label3.Caption := IntToStr(MMWheel3.Value);
    MMSpinButton3.Value := MMWheel3.Value;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
    MMWheel1Change(nil);
    MMWheel2Change(nil);
    MMWheel3Change(nil);
end;

procedure TForm1.MMWheel4Change(Sender: TObject);
begin
    Label4.Caption := IntToStr(MMWheel4.Value);
    MMSpinButton4.Value := MMWheel4.Value;
end;

procedure TForm1.MMSpinButton4Change(Sender: TObject);
begin
    MMWheel4.Value := MMSpinButton4.Value;
end;

end.
